<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../classi/Categoria.php";
    include "../template/stile.php";
    
    include "include/controlloLogin.php";
    
    $configurazioneAspetto = recuperaConfigurazioneColori($geecomDb);
    
    if(isset($_GET["id"])) {
        $categoria = new Categoria($geecomDb,filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $categoria->caricaDatiDalDatabase();
    }
    else {
        $categoria = new Categoria($geecomDb,0);
    }
    
    $tipo = ($categoria->getId()>0) ? $categoria->getTipo() : filter_input(INPUT_GET,"tipo",FILTER_SANITIZE_ADD_SLASHES);
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
        <title>Geecom CMS - Creazione categoria</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>
	
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            
            <?php 
                if(isset($_GET["status"])) {
                    $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                }
                else {
                    $status = 0;
                }
                
            ?>
            <form action="../controller/controllerCategorie.php" method="post">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Categoria creata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==210) {
                             echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Categoria duplicata, modificala per non avere due categorie uguali
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==320) {
                             echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Categoria tradotta, inserisci i testi nella lingua da te scelta
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==350) {
                             echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Componente aggiunto correttamente
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==355) {
                             echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Componente modificato correttamente
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==360) {
                             echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Impostazioni sezione componente aggiornate 
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }                       
                    ?>
                    <input type="text" class="d-none" id="operazione" value="<?= ($categoria->getId()>0) ? "modifica" : "crea" ?>">
                    <input type="text" class="d-none" id="idCategoria" value="<?=  $categoria->getId() ?>">
                    <input type="text" class="d-none" id="tipo" value="<?= $tipo ?>">
                    
                    <?php 
                        /*
                         *  se non si tratta degli articoli la categoria va gestita come una categoria di un componente,
                         *  il tipo deve corrispondere al nome del componente in modo da fare il redirect nel componente
                         *  con lo status 205, che indica la categoria 
                         */
                    	if($tipo!="categoriaArticolo") {
                    		$linkElencoCategorie = "componenti/$tipo/index.php?status=205";
                    	}
                    	else {
                    		$linkElencoCategorie = "gestioneCategorie.php";
                    	}
                    ?>
                    <div class="col-lg-8 ">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?= $linkElencoCategorie ?>">Categorie <?php if($tipo=="categoriaArticolo") echo "articoli"; else echo $tipo; ?></a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?= ($categoria->getId()>0)? $categoria->getNome() : "Nuova categoria" ?></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-primary mr-1" href="creaCategoria.php?tipo=<?php echo $tipo ?>">Crea nuova<i class="fas fa-plus ml-2"></i></a>
                                <a class="btn btn-outline-primary" href="<?= $linkElencoCategorie ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <div class="card-header py-3">
                                
                                <div class="form-row">
                                    <div class="col-12 mb-3 d-md-flex align-items-center">
                                        <label class="mr-3 mb-md-0">Categoria</label>
                                        <input type="text" class="form-control form-control-lg" id="nomeCategoria" value="<?php echo((isset($categoria)? $categoria->getNome() : ""))?>" placeholder="Nome categoria">
                                    </div>
                                
                                <?php 
                                    if($categoria->getId()>0) {
                                ?>
                                    <div class="form-group col-md-5">
                                        <label for="url-seo">Alias</label>
                                        <input type="text" class="form-control" id="alias" value="<?= $categoria->getAlias() ?>" placeholder="Alias">
                                        <small class="text-muted"> l'URL a cui è raggiungibile la pagina che indichi. Viene compilato in automatico da Geecom, ma hai la possibilità di variarlo </small>
                                    </div>

                                    <div class="form-group col-md-7">
                                        <label for="url-seo">URL</label>
                                        <input type="text" class="form-control" id="url-seo" value="<?= GeneratoreUrl::creaUrlCategoria($categoria->getDatiCategoria(), $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]) ?>" disabled>
                                        <small class="text-muted"> l'URL a cui è raggiungibile la categoria</small>
                                    </div>
                                <?php
                                    }
                                ?>
                                    <div class="form-group col-md-5">
                                        <label for="titoloPagina">Meta titolo</label>
                                        <textarea class="form-control" id="metaTitolo" name="titoloPagina" rows="2"><?php echo(($categoria->getId()!=0? $categoria->getTitoloPagina() : ""))?></textarea>
                                        <small class="text-muted">Viene inserito nel tag title della pagina</small>
                                    </div>

                                    <div class="form-group col-md-7">
                                        <label for="metaDescrizioneCategoria">Meta descrizione</label>
                                        <textarea class="form-control" id="metaDescrizioneCategoria" name="metaDescrizione" rows="2"><?php echo(($categoria->getId()!=0? $categoria->getMetaDescrizione() : ""))?></textarea>
                                        <small class="text-muted"> Inserisci una breve descrizione di questo contenuto, verrà mostrata nei risultati di ricerca di Google </small>
                                    </div>
                                    
                                    <div class="form-group col-md-6 col-xl-3">
                                        <label for="sottotitolo-articolo">Categoria madre</label>
                                        <select class="form-control" id="categoriaMadre">
                                            <option value="0">Nessuna</option>
                                            <?php
                                                if($categoria->getId()>0) {
                                                    $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE '$tipo' AND categoriaMadre = 0 AND id != {$categoria->getId()} ORDER BY posizione ASC";
                                                }
                                                else {
                                                    $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE '$tipo' AND categoriaMadre = 0 ORDER BY posizione ASC";
                                                }
                                                $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                while($categoriaPrincipale = $risNomi->fetch_assoc()) {
                                                    if(isset($categoria) && $categoria->getCategoriaMadre() == $categoriaPrincipale["id"]) {
                                                        $selezionato  = "selected";
                                                    }
                                                    else {
                                                        $selezionato  = "";
                                                    }
                                                    echo"<option value=\"{$categoriaPrincipale["id"]}\" $selezionato >{$categoriaPrincipale["nome"]}</option>";

                                                    // per ogni categoria madre vedo le categorie figlie
                                                    if(isset($categoria)) {
                                                        $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE '$tipo' AND categoriaMadre = {$categoriaPrincipale["id"]} AND id != {$categoria->getId()} ORDER BY posizione ASC";
                                                    }
                                                    else {
                                                        $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE '$tipo' AND categoriaMadre = {$categoriaPrincipale["id"]} ORDER BY posizione ASC";
                                                    }
                                                    
                                                    $risCategoriaFiglia = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                    while($categoriaFiglia = $risCategoriaFiglia->fetch_assoc()) {
                                                        if(isset($categoria) && $categoria->getCategoriaMadre() == $categoriaFiglia["id"]) {
                                                            $selezionato  = "selected";
                                                        }
                                                        else {
                                                            $selezionato  = "";
                                                        }
                                                        echo"<option value=\"{$categoriaFiglia["id"]}\" $selezionato > - {$categoriaFiglia["nome"]}</option>";
                                                    }
                                                }
                                            ?>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group col-md-6 col-xl-2">
                                        <label for="titolo-articolo">Articoli per pagina</label>
                                        <input  type="number" class="form-control" id="numeroArticoliPerPagina" value="<?= ($categoria->getId()>0)? $categoria->getElementiPerPagina() : "8" ?>" placeholder="Numero articoli per pagina">
                                    </div>
                                    
                                    <div class="form-group col-md-6 col-xl-3">
                                        <label for="sottotitolo-articolo">Tipo visualizzazione</label>
                                        <select class="form-control" id="tipoVisualizzazione">
                                            <?php
                                                if($tipo=="ecommerce") {
                                                    $arrayTipiOrdinamento = array("classico"=>"classico","background"=>"Immagini in background","presentazione"=>"presentazione");
                                                }
                                                else {
                                                    $arrayTipiOrdinamento = array("classico"=>"classico","compatto"=>"compatto","titolo"=>"solo titolo");
                                                }
                                                foreach($arrayTipiOrdinamento as $nomeDbVisualizzazione=>$nomeVisualizzazione) {
                                                    if(isset($categoria) && $categoria->getTipoVisualizzazione()==$nomeDbVisualizzazione) {
                                                        echo"<option value=\"{$nomeDbVisualizzazione}\" selected>{$nomeVisualizzazione}</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"{$nomeDbVisualizzazione}\" >{$nomeVisualizzazione}</option>";
                                                    }
                                                }
                                            ?>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group col-md-6 col-xl-4">
                                        <label for="sottotitolo-articolo">Ordinamento</label>
                                        <select class="form-control" id="ordinamento">
                                            <?php
                                                $arrayTipiOrdinamento = array("Data di pubblicazione, dal più nuovo","Data di pubblicazione, dal più vecchio","Per titolo, crescente","Per titolo, decrescente");
                                                if(isset($categoria) && $categoria->getTipo()=="ecommerce") {
                                                    array_push($arrayTipiOrdinamento,"Per prezzo, crescente");
                                                    array_push($arrayTipiOrdinamento,"Per prezzo, decrescente");
                                                }
                                                foreach($arrayTipiOrdinamento as $tipoOrdinamento) {
                                                    if(isset($categoria) && $categoria->getOrdinamento()==$tipoOrdinamento) {
                                                        echo"<option value=\"{$tipoOrdinamento}\" selected>{$tipoOrdinamento}</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"{$tipoOrdinamento}\" >{$tipoOrdinamento}</option>";
                                                    }
                                                }
                                     //            echo(($contenuto->getId()!=0? $contenuto->getCssGenerato()
                                            ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="card mx-4 mt-4 rounded-0 accordion">
                                <div class="card-header collapsed" data-toggle="collapse" href="#css-aggiuntivo">
                                    <a class="card-title">CSS aggiuntivo</a>
                                </div>
                                
                                <div id="css-aggiuntivo" class="collapse">
                                    <div class="card-body">
                                        <div class="form-group mb-4">
                                            <label for="css-aggiuntivo-area">CSS generato per questa pagina</label>
                                            <textarea disabled class="form-control" id="css-aggiuntivo-area" rows="3"><?= $categoria->getCssGenerato() ?></textarea>
                                            <small>Il CSS presente in questa textarea viene generato da Geecom a partire dalla definizione delle opzioni delle sezioni presenti in questa pagina</small>
                                        </div>

                                        <div class="form-group">
                                            <label for="css-aggiuntivo-area">CSS specifico per questa pagina</label>
                                            <textarea name="cssAggiuntivo" class="form-control" id="cssAggiuntivo" rows="3"><?= $categoria->getCssAggiuntivo() ?></textarea>
                                            <small>Definisci le classi CSS personalizzate valide solo per questa pagina</small>
                                        </div>
                                    </div>
                                </div>                     
                            </div>
                            
                            <div class="card-body wrapper-sezioni-pagina">
                                <?php
                                    if($categoria->getId()>0) {
                                ?>
                                        <div class="my-4" id="componentiPrimaDegliArticoli">
                                            <?php
                                                $categoria->stampaComponentiContenuto("categoriaSopraArticoli");
                                            ?>
                                        </div>

                                        <div class="card card-body text-center mb-3">
                                            <img class="img-fluid mx-auto" style="width:104px; height: 104px;" src="../template/img/componenti/icon_articoli_blog.svg">
                                            Articoli della categoria
                                        </div>

                                        <div class="my-4" id="componentiDopoGliArticoli">
                                            <?php
                                                $categoria->stampaComponentiContenuto("categoriaSottoArticoli");
                                            ?>
                                        </div>
                                        <button type="button" class="btn btn-success btn-block" data-toggle="modal" data-target="#aggiungi-componente"><i class="fas fa-plus"></i> Aggiungi un componente</button>
                                <?php
                                    }
                                ?>
                                <button type="button" class="btn btn-primary float-right mt-3" onclick="{operazioniCategoria('../');}"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div><!--/Colonna principale -->
                    <!-- Colonna principale -->
                    
                    <!--Colonna secondaria -->
                    <div class="col-lg-4  align-self-start sticky-top">
                        <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                            <button type="button" class="btn btn-primary w-100" onclick="{operazioniCategoria('../');}"><i class="fas fa-check mr-2"></i>Salva</button>
                            <?php 
                                if($categoria->getId()>0) {
                            ?>
                                    <button type="button" class="btn btn-warning w-100" onclick="location.href='../controller/controllerCategorie.php?id=<?php echo $categoria->getId() ?>&operazione=duplica';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                    <button type="button" class="btn btn-secondary w-100" onclick="window.open('<?php echo GeneratoreUrl::creaUrlCategoria($categoria->getDatiCategoria(), $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]) ?>');"><i class="fas fa-external-link-square-alt mr-2"></i>Visualizza</button>
                            <?php
                                }
                            
                            ?>
                        </div>
                        <div class="clearfix"></div>
                        <?php
                            if(isset($categoria)) {
                                $analisiSeo               = $categoria->eseguiAnalisiSeo();
                                $caratteriNome            = strlen($categoria->getNome());
                                $caratteriMetaDescrizione = strlen($categoria->getMetaDescrizione());
                                $caratteriDescrizione     = $categoria->contaTesto();
                        ?>
                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#SEO">
                                    <a class="card-title">
                                        SEO <?php echo $analisiSeo["esito"] ?>
                                    </a>
                                </div>
                                <div id="SEO" class="collapse p-0">
                                    <div class="card-body p-0">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item <?php echo(($caratteriNome<20) ? "text-danger" : "text-success") ?>"><strong>Nome:</strong> <?php echo $caratteriNome ?> caratteri </li>
                                            <li class="list-group-item <?php echo(($caratteriMetaDescrizione<50) ? "text-danger" : "text-success") ?>"><strong>Meta descrizione:</strong> <?php echo $caratteriMetaDescrizione ?> caratteri </li>
                                            <li class="list-group-item <?php echo(($caratteriDescrizione<500) ? "text-danger" : "text-success") ?>"><strong>Descrizione:</strong> <?php echo $caratteriDescrizione ?> caratteri </li>
                                            <?php 
                                                if(count($analisiSeo["suggerimenti"])==0) {
                                                    echo"<li class=\"list-group-item text-success\"> <i class=\"far fa-thumbs-up\"></i> Nessun suggerimento, bravo! </li>";
                                                }
                                                else {
                                                    foreach($analisiSeo["suggerimenti"] as $suggerimento) {
                                                        echo"<li class=\"list-group-item\">$suggerimento </li>";
                                                    }
                                                }
                                            ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        <?php
                            }
                        ?>
                        
                        </form>
            
                        <?php 
                            if(isset($categoria)) {
                        ?>
                        <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                            <div class="card-header collapsed" data-toggle="collapse" href="#ImmagineInEvidenza">
                                <a class="card-title">
                                    Immagine in evidenza
                                </a>
                            </div>
                            <div id="ImmagineInEvidenza" class="collapse show">
                                <div class="card-body">
                                    <div class="img-container">
                                        <div class="azioni">
                                            <div class="btn-group" role="group" aria-label="">
                                                <button onclick="eliminaImmagineInEvidenza()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                            </div>
                                        </div>
                                        <img id="immagineInEvidenza" class="img-fluid w-100 mb-3" src="../<?php echo((isset($categoria) && $categoria->getFoto()!="") ? $categoria->getFoto() : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                    </div>
                                    
                                    <button type="button" class="btn btn-outline-primary btn-block mb-3" onclick="apriPopupSelezioneImmagini()"><i class="far fa-image"></i> Scegli da immagini caricate</button>
                                    
                                    <form action="../controller/controllerCategorie.php" id="frmFileUpload-00" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                        <div class="dz-message">
                                            <i class="fas fa-file-upload fa-2x mb-2"></i>
                                            <h5>Trascina o carica qui l'immagine</h5>
                                        </div>
                                        <div class="fallback">
                                            <input name="file" type="file" />
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
            
                        <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                            <div class="card-header collapsed" data-toggle="collapse" href="#traduzioni" aria-expanded="false">
                                <a class="card-title">
                                    Traduzioni
                                </a>
                            </div>
                            <div id="traduzioni" class="collapse show" style="">
                                <div class="card-body ">
                                    
                                    <div class="d-flex justify-content-between  align-items-center">
                                        <span>Questa categoria è in <strong><?php echo strtoupper($categoria->getLingua()) ?></strong> </span>
                                        <img src="../<?php echo percorsoImmagineBandiera($categoria->getLingua()) ?>" alt="<?php echo $categoria->getLingua() ?>">
                                    </div>
                                    <div id="boxTraduzioni">
                                    <?php 
                                        if($categoria->getId()!=0) {
                                            $categoria->stampaBoxTraduzioni();
                                        }
                                    ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                            }
                        ?>
                    </div><!--/Colonna secondaria -->
            </div>
        </div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/operazioneCompletata.php";
        
        if($categoria->getId()!=0) {
            $contenuto = $categoria;
            include "include/modalAggiungiComponenteCategoria.php";
            include "include/modalAggiungiComponenteSezione.php";
        }
        
        include "include/modal/modalMenuComponenti.php";
        
        include "include/modal/contenuti/modalModificaComponenteContenuto.php";

        include "include/modal/contenuti/modalEliminaComponenteContenuto.php";
                
        include "include/modal/modalSelezionaFoto.php";
    ?>
        <!-- Modifica impostazioni sezione -->
	<div class="modal fade" id="modifica-impostazioni-sezione" tabindex="-1" role="dialog" aria-labelledby="modifica impostazioni sezione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Opzioni sezione</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form name="formImpostazioniSezione" action="../controller/controllerCategorie.php" method="post" enctype="multipart/form-data">
                            <input type="text" class="d-none" name="id" value="<?= $categoria->getId() ?>">
                            <input type="text" class="d-none" id="idSezioneDaModificare" name="idSezioneDaModificare">
                            <input type="text" class="d-none" name="operazione" value="modificaOpzioniSezione">
                            <div class="form-group row">
                                  <label for="idSezione" class="col-sm-2 col-form-label">ID</label>
                                  <div class="col-sm-10">
                                    <input type="text" class="form-control" id="idSezione" name="idSezione" placeholder="ID">
                                    <small class="form-text text-muted"> L'ID deve essere unico </small>
                                  </div>
                            </div>
                            <div class="form-group row">
                                  <label for="classeSezione" class="col-sm-2 col-form-label">Classi</label>
                                  <div class="col-sm-10">
                                    <input type="text" class="form-control" id="classeSezione" name="classeSezione" placeholder="classi">
                                    <small class="form-text text-muted"> Inserisci le classi aggiuntive separate da uno spazio, ad es.: "mt-0 bg-dark text-negative"</small>
                                  </div>
                            </div>
                            <hr>
                            <div class="form-group" id="contenitoreCheckboxLarghezza">
                                <input type="checkbox" id="sezioneATuttaLarghezza" name="sezioneATuttaLarghezza" value="si" />
                                <label>A tutta larghezza</label>
                            </div>
                            <hr>
                            <div class="form-row">
                                <div class="form-group col-sm-6">
                                    <label>Margine</label>
                                    <input type="text" class="form-control" id="margineSezione" name="margineSezione" value="">
                                    <small class="form-text text-muted"> Personalizza il margine della sezione, ad es.: "1em 1em 1em 1em"</small>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>Padding</label>
                                    <input type="text" class="form-control" id="paddingSezione" name="paddingSezione" placeholder="">
                                    <small class="form-text text-muted"> Personalizza il padding della sezione, ad es.: "1em 1em 1em 1em"</small>
                                </div>
                            </div>

                            <hr class="mt-0">
                            <h6> Colore di sfondo </h6>
                            <div class="form-row">
                                <div class="form-group col-sm-6">
                                    <div id="divContenitoreColorPicker" class="">
                                        
                                    </div>
                                    <small class="form-text text-muted">Se non impostato la sezione avrà uno sfondo trasparente</small>
                                </div>
                                <div class="form-group col-sm-6">
                                    <select class="form-control" id="colore-predefinito-valore" onchange="aggiornaColoreSezione()">
                                        <option value="">Seleziona tra i colori predefiniti</option>
                                        <option value="<?php echo $configurazioneAspetto["colorePrimario"] ?>">Primary</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreSecondario"] ?>">Secondary</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreSuccess"] ?>">Success</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreDanger"] ?>">Danger</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreWarning"] ?>">Warning</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreInfo"] ?>">Info</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreDark"] ?>">Dark</option>
                                        <option value="<?php echo $configurazioneAspetto["coloreLight"] ?>">Light</option>
                                    </select>
                                </div>
                            </div>
                            
                            <hr class="mt-0">
                            <div class="form-row">
                                <div class="form-group col-sm-9">
                                    <h6> Immagine di sfondo </h6>
                                    <input name="file" type="file" accept="image/*"/>
                                    <small class="d-block text-muted form-text">Se presente, l'immagine di sfondo verrà visualizzata al posto del video sui dispositivi che non ne consentono la riproduzione.</small>
                                </div>
                                <div class="form-group col-sm-3">
                                    <div class="img-container">
                                        <div class="azioni">
                                            <div class="btn-group" role="group" aria-label="">
                                                <button onclick="eliminaImmagineSezione()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                            </div>
                                        </div>
                                        <img id="immagineDiSfondoSezione" class="img-fluid"  alt="immagine sezione">
                                    </div>
                                </div>
                            </div>
                            
                            <hr class="mt-0">
                            <div class="form-row">
                                <div class="form-group col-sm-9">
                                    <h6> Video di sfondo </h6>
                                    <input name="video" type="file" accept="video/*" />
                                </div>
                                <div class="form-group col-sm-3">
                                    <div class="video-container">
                                        <div class="azioni">
                                            <div class="btn-group" role="group" aria-label="">
                                                <button onclick="eliminaVideoSezione()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                            </div>
                                        </div>
                                        <video id="videoDiSfondoSezione" class="embed-responsive embed-responsive-16by9" poster="../immagini/altro/segnaposto.png" >
                                            <source id="sorgenteVideoDiSfondo" src="" type="video/mp4">
                                        </video>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                          <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                          <button type="button" class="btn btn-primary btn-sm" onclick="document.formImpostazioniSezione.submit()"><i class="fas fa-check"></i> Salva</button>
                    </div>
                  </div>
            </div>
        </div>
        
        <div class="modal fade" id="modalEliminaComponenteSezioneMultipla" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare il componente?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteSezioneDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center">
                                <span class="mr-3 align-self-center text-primary"><em id="nomeComponenteSezioneDaEliminare"></em></span>
                                <div id="nomeElementoSezioneDaEliminare"></div>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="componenteSezioneDaEliminare">
                        <input type="text" class="d-none" id="idSezioneComponenteDaEliminare">
                        <input type="text" class="d-none" id="idPosizioneComponenteDaEliminare">
                        <input type="text" class="d-none" id="tabellaSezioneComponenteDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneComponenteSezione()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
    <?php
        include "include/jsBaseAreaAmministrativa.php";
    ?>
        <!-- Dropzone -->
        <script type="text/javascript" src="../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.webp,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineInEvidenza").src="../"+response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"cambiaImmagine",
                    id:<?php echo $categoria->getId() ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
        </script>

        <script>
            function aggiungiComponenteCategoria(idComponente) {
                var tipoElemento = document.getElementById("sopraOSottoArticoli").value;
                aggiungiComponenteContenuto("../",<?= $categoria->getId() ?>,idComponente,tipoElemento);
                location.href = "creaCategoria.php?id=<?= $categoria->getId() ?>&status=350";
            }
            
            function eliminaImmagineInEvidenza() {
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerCategorie.php",
                    data:{
                        operazione:"eliminaImmagine",
                        id:<?php echo $categoria->getId() ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineInEvidenza").src="../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function apriPopupSelezioneImmagini() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaCategorie",
                        id:<?php echo $categoria->getId() ?>,
                        immaginePartenza:0,
                        numeroImmagini:18
                    },
                    success:function(codice) {
                        document.getElementById("divSelezioneFoto").innerHTML = codice;
                        $('#modal-seleziona-foto').modal('show');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function cambiaImmagineInEvidenzaDaPopup(percorso) {
                cambiaImmagineInEvidenzaCategoria('../',<?php echo $categoria->getId(); ?>,percorso);
                document.getElementById("immagineInEvidenza").src="../"+percorso;
                $('#modal-seleziona-foto').modal('hide');
            }
            
            function aggiungiImmaginiModalSelezioneImmagini(immaginePartenza,numeroImmagini) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaCategorie",
                        id:<?php echo $categoria->getId() ?>,
                        immaginePartenza:immaginePartenza,
                        numeroImmagini:numeroImmagini
                    },
                    success:function(codice) {
                        var vecchioCodice = document.getElementById("divSelezioneFoto").innerHTML; 
                        document.getElementById("divSelezioneFoto").innerHTML = vecchioCodice+codice;
                        
                        // aggiorno i dati del pulsante
                        var nuovaImmagineDiPartenza = immaginePartenza+numeroImmagini;
                        document.getElementById("divBottoneModalSelezionaFoto").innerHTML = '<button type="button" class="btn btn-outline-primary" onclick="aggiungiImmaginiModalSelezioneImmagini('+nuovaImmagineDiPartenza+','+numeroImmagini+')">Mostra altre immagini</button>';
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function traduci(id) {
                var l =$('#linguaTraduzione').val();
                if(l=="") {
                    alert("Seleziona una lingua");
                } 
                else {            
                    location.href="../controller/controllerCategorie.php?id="+id+"&operazione=traduci&lingua="+l;
                }
            }
           
            function duplicaComponente(idComponente) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"duplicaComponente",
                        id:<?= $categoria->getId() ?>,
                        idComponente:idComponente
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaComponentiContenuto();
                        }
                        else if(esito=="ok,ricarica") {
                            aggiornaComponentiContenuto();
                            location.reload();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function aggiornaComponentiContenuto() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerCategorie.php",
                    data:{
                        operazione:"stampaComponentiContenuto",
                        tipoElemento:"categoriaSopraArticoli",
                        id:<?= $categoria->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("componentiPrimaDegliArticoli").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
                
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerCategorie.php",
                    data:{
                        operazione:"stampaComponentiContenuto",
                        tipoElemento:"categoriaSottoArticoli",
                        id:<?= $categoria->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("componentiDopoGliArticoli").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function modificaImpostazioniSezione(id,idSezione,classeSezione,aTuttaLarghezza,margineSezione,paddindSezione,coloreSfondo,immagineDiSfondo,videoDiSfondo) {
                document.getElementById("idSezioneDaModificare").value = id;
                document.getElementById("idSezione").value      = idSezione;
                document.getElementById("classeSezione").value  = classeSezione;
                document.getElementById("margineSezione").value = margineSezione;
                document.getElementById("paddingSezione").value = paddindSezione;
                
                if (typeof switchModalSezione !== 'undefined') {
                    switchModalSezione.destroy();
                    document.getElementById("contenitoreCheckboxLarghezza").innerHTML = "";
                    
                    document.getElementById("contenitoreCheckboxLarghezza").innerHTML = "<input type=\"checkbox\" id=\"sezioneATuttaLarghezza\" name=\"sezioneATuttaLarghezza\" value=\"si\" /><label>A tutta larghezza</label>";                    
                }
                
                var checkboxSezioneATuttaLarghezza = document.getElementById("sezioneATuttaLarghezza");
                if(aTuttaLarghezza==='si') {    
                    checkboxSezioneATuttaLarghezza.checked   = true;
                }
                checkboxSezioneATuttaLarghezza.className = "js-switch-modal";
                
                var elementoSwitchModal = document.querySelector('.js-switch-modal');
                switchModalSezione  = new Switchery(elementoSwitchModal,{ size: 'small', color: 'var(--primary)', jackColor: '#FFF' });
                
                // creo il colorpicker
                if (typeof colorPickerSezione !== 'undefined') {
                    $('.selettore-colore').colorpicker('destroy');
                    
                    document.getElementById("divContenitoreColorPicker").innerHTML = "<input type=\"text\" id=\"coloreSfondo\" name=\"coloreSfondo\" class=\"form-control\" /><span class=\"input-group-append\"><span class=\"input-group-addon input-group-text\"><i></i></span></span>";
                    document.getElementById("divContenitoreColorPicker").className = "input-group colorpicker-component selettore-colore";
                    document.getElementById("coloreSfondo").value   = coloreSfondo;

                    colorPickerSezione = $('.selettore-colore').colorpicker({
                        format: 'hex'
                    });
                }
                else {
                
                    document.getElementById("divContenitoreColorPicker").innerHTML = "<input type=\"text\" id=\"coloreSfondo\" name=\"coloreSfondo\" class=\"form-control\" /><span class=\"input-group-append\"><span class=\"input-group-addon input-group-text\"><i></i></span></span>";
                    document.getElementById("divContenitoreColorPicker").className = "input-group colorpicker-component selettore-colore";
                    document.getElementById("coloreSfondo").value   = coloreSfondo;

                    colorPickerSezione = $('.selettore-colore').colorpicker({
                        format: 'hex'
                    });
                }
                
                if(immagineDiSfondo=="") {
                    document.getElementById("immagineDiSfondoSezione").src = "../immagini/altro/segnaposto.png";
                }
                else {
                    document.getElementById("immagineDiSfondoSezione").src = "../"+immagineDiSfondo;
                }
                
                var video = document.getElementById("videoDiSfondoSezione");
                if(videoDiSfondo=="") {
                    video.setAttribute('poster','../immagini/altro/segnaposto.png');
                    if (video.hasAttribute("controls")) {
                        video.removeAttribute("controls")   
                    }
                }
                else {
                    video.removeAttribute('poster');
                    if (!video.hasAttribute("controls")) {
                        video.setAttribute("controls","controls")   
                    }
                    document.getElementById("sorgenteVideoDiSfondo").src = "../"+videoDiSfondo;
                    video.load();
                }
                
                $('#modifica-impostazioni-sezione').modal('show');
            }
            
            function apriPopupAggiungiComponenteSezione(idSezione,posizioneComponente,tabellaSezione) {
                $('#idSezioneNuovoElemento').val(idSezione);
                $('#posizioneNuovoElementoSezione').val(posizioneComponente);
                $('#tabellaSezioneNuovoElemento').val(tabellaSezione);
                
                $('#aggiungi-componente-sezione').modal('show');
            }
            
            function eseguiAggiuntaComponenteSezione(idComponente) {
                var idContenuto                   = $('#idPaginaSezione').val();
                var idSezioneNuovoElemento        = $('#idSezioneNuovoElemento').val();
                var posizioneNuovoElementoSezione = $('#posizioneNuovoElementoSezione').val();
                var tabellaSezioneNuovoElemento   = $('#tabellaSezioneNuovoElemento').val();
                
                aggiungiComponenteSezioneContenuto("../",idContenuto,idComponente,idSezioneNuovoElemento,tabellaSezioneNuovoElemento,posizioneNuovoElementoSezione);
                location.href = "creaCategoria.php?id=<?= $categoria->getId() ?>&status=350";
            }
                        
            function aggiornaDivSezioneMultipla(id) {
                var proporzioniSezione = $('#proporzioniSezione'+id).val();
                var arrayClassi        = proporzioniSezione.split(",");
                
                document.getElementById('div1SezioneMultipla'+id).className = arrayClassi[0]+" d-flex align-items-stretch";
                document.getElementById('div2SezioneMultipla'+id).className = arrayClassi[1]+" d-flex align-items-stretch";
                if(arrayClassi.length==3) {
                    document.getElementById('div3SezioneMultipla'+id).className = arrayClassi[2]+" d-flex align-items-stretch";
                }
            }
            
            function salvaDatiSezioneMultipla(id,tabella) {
                
                if(tabella!="geec_sezioniAQuattroColonne") {
                    var proporzioni  = document.getElementById('proporzioniSezione'+id).value;
                }
                else {
                    var proporzioni  = "";
                }
                var allineamento = document.getElementById('allineamentoSezione'+id).value;
                
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"cambiaDatiSezioneMultipla",
                        tabella:tabella,
                        idSezione:id,
                        proporzioni:proporzioni,
                        allineamento:allineamento
                    },
                    success:function(result) {
                        if(result=="ok") {
                            $('#labelOperazioneCompletata').text("Dati sezione aggiornati");
                            $('#modalOperazioneCompletata').modal('show');
                        }
                        else {
                            alert(result)
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaColoreSezione() {
                var coloreSfondo = document.getElementById("colore-predefinito-valore").value;
                
                if(coloreSfondo!="") {
                    document.getElementById("coloreSfondo").value   = coloreSfondo;
                    $('.selettore-colore').colorpicker('setValue', coloreSfondo);
                }
            }
            
            function eliminaComponenteSezione(id,idSezione,posizioneComponente,immagineComponente,nomeComponente,nomeElemento,tabellaSezione) {
                $('#componenteSezioneDaEliminare').val(id);
                $('#idSezioneComponenteDaEliminare').val(idSezione);
                $('#idPosizioneComponenteDaEliminare').val(posizioneComponente);
                $('#tabellaSezioneComponenteDaEliminare').val(tabellaSezione);
                document.getElementById("immagineComponenteSezioneDaEliminare").src = immagineComponente;
                $('#nomeComponenteSezioneDaEliminare').text(nomeComponente);
                document.getElementById("nomeElementoSezioneDaEliminare").innerHTML = nomeElemento;
                $('#modalEliminaComponenteSezioneMultipla').modal('show');
            }
            
            function eseguiEliminazioneComponenteSezione() {
                var id        = $('#componenteSezioneDaEliminare').val();
                var idSezione = $('#idSezioneComponenteDaEliminare').val();
                var tabellaSezione    = $('#tabellaSezioneComponenteDaEliminare').val();
                var posizioneElemento = $('#idPosizioneComponenteDaEliminare').val();
                
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaComponenteSezione",
                        id:id,
                        idSezione:idSezione,
                        tabellaSezione:tabellaSezione,
                        posizioneElemento:posizioneElemento
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            location.reload();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eliminaImmagineSezione() {
                var idSezione = document.getElementById("idSezioneDaModificare").value;
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaImmagineSezione",
                        id:<?php echo $contenuto->getId() ?>,
                        idSezione:idSezione
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineDiSfondoSezione").src="../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eliminaVideoSezione() {
                var idSezione = document.getElementById("idSezioneDaModificare").value;
                
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaVideoSezione",
                        id:<?php echo $contenuto->getId() ?>,
                        idSezione:idSezione
                    },
                    success:function(result) {
                        if(result=="ok") {
                            var video = document.getElementById("videoDiSfondoSezione");
                            video.pause();
                            video.removeAttribute('controls');
                            video.setAttribute('poster','../immagini/altro/segnaposto.png');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
  </body>
</html>
